#ifndef __KALUGA__BSO__HEADER__
#define __KALUGA__BSO__HEADER__

#include "pch.h"
#include "FTNStruc.hpp"

#ifndef MAX_PATH
#define MAX_PATH 260
#endif

class CBSOManager {
public:
	CBSOManager();
	virtual ~CBSOManager();

	virtual void setAddress(const SFTNAddress& addr, FlavourType routeType);

	virtual void setTempOutboundAddress(const SFTNAddress& addr, FlavourType routeType);
	/**
	 * Collects entries that are found in temp outbound;
	 * each entry is represented by its name without startup path.
	 * This approach allows to check temp outbound for entries in a quick manner:
	 * first collecting all entries, then checking each link against each entry.
	 * You can check entry by means of <code>getTempEntryName</code> method 
	 * (just compare entry name from this method and entry name you have).
	 */
	virtual void collectTempEntries(VTString& entries);
	virtual void getTempEntryName(const SFTNAddress& addr,
								  FlavourType routeType, tstring& entryName);
	/**
	 * You should append entry to the header and you will get full entry name
	 */
	virtual void getTempEntryPath(tstring& header);

	virtual TCHAR getRouteChar(FlavourType routeType);

	virtual bool setBusyFlag();
	virtual bool clearBusyFlag();
	virtual bool isBusyFlagExist();

	virtual LPCTSTR getName()    const { return (name); }
	virtual LPCTSTR getNameExt() const { return (name + nameLen); }
	virtual int     getNameLen() const { return (nameLen); }

private:
    TCHAR	baseDir[MAX_PATH];
    TCHAR	defaultDomainDir[MAX_PATH];
    int		numberOfBaseDirNames;
    TCHAR	name[MAX_PATH];
    int		nameLen;
};

#endif